package edu.uky.ai.lp.ai;

import edu.uky.ai.lp.logic.Expression;
import edu.uky.ai.lp.logic.Unifier;

/**
 * A prover is a {@link Continuation} used to find all the ways that a given
 * logical expression can be proved true.
 * 
 * @author Stephen G. Ware
 * @param <E> the type of expression to be proved
 */
public abstract class Prover<E extends Expression> extends Continuation<Unifier> {

	/** The expression to be proved */
	public final E expression;
	
	/** The unifier as it stands before the proof begins */
	public final Unifier unifier;
	
	/**
	 * Constructs a prover for a given expression and current unifier.
	 * 
	 * @param expression the expression to be proved
	 * @param unifier the unifier as it stands before the proof
	 */
	public Prover(E expression, Unifier unifier) {
		this.expression = expression;
		this.unifier = unifier;
	}
	
	@Override
	public String toString() {
		return expression.substitute(unifier).toString();
	}
}
